package com.izenpe.zain.cliente.cades.multiples;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartSignRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartSignResponse;

public class GeneracionFirmaCades_ES_T_Attached_Serie {

	private static final String fileName = "HelloWorld.txt";
	
	public static void main(String[] args) {
		try{
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);
			SmartSignRequest smartSignReq = new SmartSignRequest(Propiedades.ZAIN_ENDPOINT);
			smartSignReq.setProfile(Constants.Profile.CMSPKCS7);
			smartSignReq.setSignatureType(Constants.SignatureType.CADES);
			smartSignReq.setSignatureFormat(Constants.SignatureFormat.ES_T);
			smartSignReq.setEnvelopingSignature(true);
			smartSignReq.setLanguage("es");
			smartSignReq.setKeySubjectName(Propiedades.ZAIN_SIGNER);
			smartSignReq.setInputBase64Data(Base64.encode(ZainUtil.readBinaryFile("data/input/" + fileName)));
			SmartSignResponse smartSignResp = smartSignReq.send();
			if (Constantes.RMAJOR_SUCCESS.equals((smartSignResp.getResultMajor()))
					&& smartSignResp.getResultMinor() == null) {
				String signBase64 = smartSignResp.getSignatureBase64();
				SmartSignRequest smartSignReqCosign = new SmartSignRequest(Propiedades.ZAIN_ENDPOINT);
				smartSignReqCosign.setProfile(Constants.Profile.CMSPKCS7);
				smartSignReqCosign.setLanguage("es");
				smartSignReqCosign.setKeySubjectName(Propiedades.ZAIN_SIGNER);
				smartSignReqCosign.setSignatureFormat(Constants.SignatureFormat.ES_T);
				smartSignReqCosign.setSignatureType(Constants.SignatureType.CADES);
				smartSignReqCosign.setEnvelopingSignature(true);
				// Para que sea firma en serie se mete en el atributo reservado
				// al documento, la firma generada en la peticion anterior
				smartSignReqCosign.setInputBase64Data(signBase64);

				SmartSignResponse smartSignResponse = smartSignReqCosign.send();

				if (Constantes.RMAJOR_SUCCESS.equals((smartSignResponse.getResultMajor()))
						&& smartSignResponse.getResultMinor() == null) {
					String destFilename = "data/output/" + fileName + "CADES_ES_TAttachedSerie.p7s";
					signBase64 = smartSignResponse.getSignatureBase64();
					byte[] data = Base64.decode(signBase64);
					ZainUtil.writeBinaryFile(destFilename, data);
					System.out.println("La firma ha sido generada con xito");
				}
			} else {
				System.out.println("Error en la Generacin de Firma:" + smartSignResp.getResultMessage());
			}
		}catch (Exception e) {
			e.printStackTrace();
		}
	}

}
